<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Twig;

use PrestaShop\PrestaShop\Adapter\Admin\UrlGenerator;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

/**
 * @internal
 */
final class LegacyLinkExtension extends AbstractExtension
{
    /**
     * @var UrlGenerator
     */
    private $urlGenerator;

    public function __construct(UrlGeneratorInterface $legacyUrlGenerator)
    {
        $this->urlGenerator = $legacyUrlGenerator;
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('gls_poland_legacy_link', [$this, 'getLegacyPath']),
        ];
    }

    public function getLegacyPath(string $controller, array $parameters = []): string
    {
        return $this->urlGenerator->generate($controller, $parameters);
    }
}
