<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Hook\Front\Checkout;

use Gls\GlsPoland\PrestaShop\Checkout\CheckoutResolverInterface;
use Gls\GlsPoland\PrestaShop\Checkout\ModuleCheckoutInterface;
use Gls\GlsPoland\PrestaShop\Hook\HookInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * @deprecated use {@see DisplayBeforeBodyClosingTag} instead
 */
final class DisplayAfterCarrier implements HookInterface
{
    public const HOOK_NAME = 'displayAfterCarrier';

    private $checkoutResolver;

    public function __construct(CheckoutResolverInterface $checkoutResolver)
    {
        $this->checkoutResolver = $checkoutResolver;
    }

    /**
     * @param array{request: Request} $parameters
     */
    public function execute(array $parameters): string
    {
        if (null === $checkout = $this->checkoutResolver->resolve($parameters['request'] ?? null)) {
            return '';
        }

        if ($checkout instanceof ModuleCheckoutInterface) {
            return '';
        }

        return $checkout->renderMapModal();
    }
}
