<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Event;

use Gls\GlsPoland\EventDispatcher\Event;
use Symfony\Component\HttpFoundation\Request;

final class FrontControllerInitializedEvent extends Event
{
    /**
     * @var \FrontControllerCore
     */
    private $controller;

    /**
     * @var Request|null
     */
    private $request;

    public function __construct(\FrontControllerCore $controller, ?Request $request = null)
    {
        $this->controller = $controller;
        $this->request = $request;
    }

    public function getController(): \FrontControllerCore
    {
        return $this->controller;
    }

    public function getRequest(): ?Request
    {
        return $this->request;
    }
}
