<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Configuration\Api;

use Gls\GlsPoland\AdePlus\UserCredentialsInterface;

interface PersistentConfigurationInterface extends ConfigurationInterface
{
    public function asNonPersistent(): ConfigurationInterface;

    public function save(ConfigurationInterface $configuration);

    /**
     * @return UserCredentialsInterface|null test credentials if sandbox is enabled, production credentials otherwise
     */
    public function getCredentials(): ?UserCredentialsInterface;
}
