<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Services;

use Gls\GlsPoland\AdePlus\Authorization\AuthorizedRequest;

final class GetGuaranteed extends AuthorizedRequest
{
    /**
     * @var string
     */
    private $zipcode;

    public function __construct(string $zipcode)
    {
        $this->zipcode = $zipcode;
    }

    public function jsonSerialize(): array
    {
        return [
            'zipcode' => $this->zipcode,
        ];
    }

    public function getZipcode(): string
    {
        return $this->zipcode;
    }

    public function withZipcode(string $zipcode): GetGuaranteed
    {
        $new = clone $this;
        $new->zipcode = $zipcode;

        return $new;
    }
}
