<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Pickup;

use Gls\GlsPoland\AdePlus\Authorization\AuthorizedRequest;

final class GetConsignmentBindings extends AuthorizedRequest
{
    /**
     * @var int
     */
    private $id;

    public function __construct(int $pickupId)
    {
        $this->id = $pickupId;
    }

    public function jsonSerialize(): array
    {
        return [
            'id' => $this->id,
        ];
    }

    public function getPickupId(): int
    {
        return $this->id;
    }

    public function withPickupId(int $id): GetConsignmentBindings
    {
        $new = clone $this;
        $new->id = $id;

        return $new;
    }
}
